<?php
define('DURACION_SESION', '18000'); //2 horas
ini_set("session.cookie_lifetime", DURACION_SESION);
ini_set("session.gc_maxlifetime", DURACION_SESION);
ini_set("session.save_path", "/tmp");
session_cache_expire(DURACION_SESION);
session_start();
session_regenerate_id(true);
require_once("common/constantes.php");
require_once("dbSelectProductos.php");


//### IM : Nueva Gestion de Permisos
global $boolEsManager;
$boolEsManager = false;
$perfilId = $_SESSION['idPerfil'];
if ($perfilId == 1) {
	$boolEsManager = True;
}
if ($perfilId == "") {
	echo "<script>top.location.href='login.php';</script>";
}
//### IM : Nueva Gestion de Permisos

error_reporting(E_ALL & ~E_NOTICE);
ini_set('display_errors', '1');

global $argAccion;
$argAccion      = $_REQUEST['argAccion'];


if ($argAccion == "Filtrar") {
	$txtCodigo 	= $_REQUEST['txtCodigo'];
	$cmbCategoriaBuscar	= $_REQUEST['cmbCategoria'];
	$cmbStock	= $_REQUEST['cmbStock'];
	$cmbEstado	= $_REQUEST['cmbEstado'];
} else {
	$cmbEstado	= 1;
}

if ($argAccion == "Nomina") {
	$txtCodigo 	= $_REQUEST['txtCodigo'];
	$cmbCategoriaBuscar	= $_REQUEST['cmbCategoria'];
	$cmbStock	= $_REQUEST['cmbStock'];
	$cmbEstado	= $_REQUEST['cmbEstado'];
} else {
	$cmbEstado	= 1;
}


global $arrProductos, $intTotalProductos;

$arrProductos     = select_Productos_filtro($txtCodigo, $cmbStock,  $cmbCategoriaBuscar, $cmbEstado);


$intTotalProductos        = count($arrProductos);

//defino constantes de acceso
$constProductoId    	= 0;
$constCodigoPLU     	= 1;
$constCodigoBarra   	= 2;
$constDescripcion    	= 3;
$constValor    			= 4;
$constValorDescuento	= 5;
$constValorFinal		= 6;
$constCategoria    		= 7;
$constObservaciones 	= 8;
$constStock				= 9;
$constStockMinimo		= 10;
$constUnidad			= 11;
$constEstaActivo		= 12;

//busco en base de datos todas las categorias existentes
$arrCategoriaProductos = select_CategoriaProductos();
//defino constantes
$constCategoriaId = 0;
$constCategoriaNombre = 1;
$intTotalCategoriaProductos = count($arrCategoriaProductos);


?>
<html>

<head>
	<title><?php echo $gen_nombreSitio; ?></title>
	<link href="css/estilo.css" rel="stylesheet" type="text/css" />

	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" />
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

	<link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/dataTables.bootstrap4.min.css">
	<script src="https://cdn.datatables.net/1.11.4/js/jquery.dataTables.min.js"></script>
	<script src="https://cdn.datatables.net/1.11.4/js/dataTables.bootstrap4.min.js"></script>
	<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

	<link href="css/tabla-responsiva.css" rel="stylesheet" type="text/css" />
	<link href="css/producto.css" rel="stylesheet" type="text/css" />

	<!-- excel -->

	<script src="https://unpkg.com/xlsx/dist/xlsx.full.min.js"></script>
	<!-- excel -->

	<script id="formatoDatatable" type="text/javascript" src="js/formato-dataTable.js"></script>
	<script id="idioma" type="text/javascript" src="js/idiomas.js"></script>

	<script>
		function nuevo() {
			document.frmProducto.action = "frmProducto.php?productoId=&argAccion=";
			document.frmProducto.submit();
		}

		function onClikSalir() {
			document.forms["frmProducto"].argAccion.value = "Salir";
			document.forms["frmProducto"].submit();
		}

		function filtrar() {
			document.frmProducto.action = "vwProductos.php";
			document.frmProducto.argAccion.value = "Filtrar";
			document.frmProducto.submit();
		}

		function onClickVolver() {
			document.forms["frmProducto"].action = "vwConfiguracion.php";
			document.forms["frmProducto"].submit();
		}

		function onClickActualizar() {
			document.forms["frmProducto"].action = "vwProductosStock.php";
			document.forms["frmProducto"].submit();
		}

		function bajarNomina() {
    // Configura la solicitud AJAX
    $.ajax({
        url: "nominaProductos.php", // La URL del script que genera el JSON
        type: "POST",
        data: {
            txtCodigo: "<?php echo $txtCodigo; ?>",
            cmbStock: "<?php echo $cmbStock; ?>",
            cmbCategoriaBuscar: "<?php echo $cmbCategoriaBuscar; ?>",
            cmbEstado: "<?php echo $cmbEstado; ?>",
            argAccion: "Nomina"
        },
        success: function(response) {
            let jsonProducts = JSON.parse(response);

            // Crea un libro de Excel
            var wb = XLSX.utils.book_new();
            wb.Props = {
                Title: "Productos",
                Author: "By-Sal Ltda",
                CreatedDate: new Date()
            };

            // Convierte los datos JSON a una hoja de cálculo
            var ws = XLSX.utils.json_to_sheet(jsonProducts);

            // Agrega la hoja de cálculo al libro
            XLSX.utils.book_append_sheet(wb, ws, "Productos");

            // Convierte el libro a datos binarios
            var wbout = XLSX.write(wb, { bookType: 'xlsx', type: 'binary' });

            // Función para convertir los datos binarios a Blob
            function s2ab(s) {
                var buf = new ArrayBuffer(s.length);
                var view = new Uint8Array(buf);
                for (var i = 0; i < s.length; i++) {
                    view[i] = s.charCodeAt(i) & 0xFF;
                }
                return buf;
            }

            // Crea un Blob y un enlace para descargar el archivo
            var blob = new Blob([s2ab(wbout)], { type: 'application/octet-stream' });
            var link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = 'productos.xlsx';
            link.click();
        }
    });
}
	</script>
</head>
<form name="frmProducto" method="post">
	<input name="argAccion" type="hidden" value="<? echo $argAccion ?>">
	<div id="pagina">
		<div id="cabecera">
			<?php require_once("menuDefinicion.php"); ?>
		</div>
		<div id="contenido">
			<div class="container-fluid overflow-auto" style="width : 95%;">
				<span class="cssMenuSistema list-group-item  lista-item text-center active h5 text-uppercase detalle" data-remote="true" href="#" id="categoria_0">
					Productos
				</span>
				<div class="d-flex justify-content-between flex-wrap">
					<div class="col-md-12 col-sm-12 col-xs-12  card text-left mb-4 px-0">
						<div class="card-header cssMenuSistema text-left">
							busqueda
						</div>
						<div class="card-body d-flex justify-content-between p-0 pt-1 ml-3">
							<div class="form-row col-12 d-flex justify-content-between">
								<div class="form-group col-md-2 col-sm-6 col-xs-12 mt-4">
									<input type="text" class="form-control " placeholder=" " value="<? echo $txtCodigo ?>" name="txtCodigo" id="txtCodigo">
									<label class="form-control-placeholder" for="txtCodigo">NOMBRE / CODIGO PRODUCTO</label>
								</div>
								<div class="form-group col-md-2 col-sm-6 mt-4">
									<select name="cmbStock" class="form-control text-uppercase pl-0" id="cmbStock">
										<option <? if ($cmbStock == 0) echo 'selected' ?> value='0'>--TODOS--</option>
										<option <? if ($cmbStock == 1) echo 'selected' ?> value='1'>MENOR AL MINIMO</option>
										<option <? if ($cmbStock == 2) echo 'selected' ?> value='2'>NO DISPONIBLE</option>

									</select>
									<label class="form-control-placeholder text-uppercase" for="cmbStock">STOCK</label>
								</div>
								<div class="form-group col-md-2 col-sm-6 mt-4">
									<select name="cmbCategoria" class="form-control text-uppercase pl-0" id="cmbCategoria">
										<?php
										echo "<option value='0'  ";
										if ($productoCategoria == 0) {
											echo "selected";
										}
										echo ">--- TODOS --- </option>";

										if ($intTotalCategoriaProductos >= 1) {
											for ($j = 0; $j < $intTotalCategoriaProductos; $j++) {
												$categoriaId   = $arrCategoriaProductos[$j][$constCategoriaId];
												$categoria     = $arrCategoriaProductos[$j][$constCategoriaNombre];
												echo "<option value='" .  $categoriaId . "' ";
												if ($cmbCategoriaBuscar == $categoriaId) {
													echo "selected";
												}
												echo " >";
												echo $categoria . "</option>";
											}
										}
										?>
									</select>
									<label class="form-control-placeholder text-uppercase" for="cmbFormaDePago">CATEGORIA </label>
								</div>
								<div class="form-group col-md-2 col-sm-6 mt-4">
									<select name="cmbEstado" class="form-control text-uppercase pl-0" id="cmbEstado">
										<option <? if ($cmbEstado == -1 || !is_numeric($cmbEstado)) echo 'selected' ?> value='-1'>--TODOS--</option>
										<option <? if ($cmbEstado == 1) echo 'selected' ?> value='1'>Activo</option>
										<option <? if ($cmbEstado == 0  && is_numeric($cmbEstado)) echo 'selected' ?> value='0'>No Activo</option>
									</select>
									<label class="form-control-placeholder text-uppercase" for="cmbEstado">ESTADO</label>
								</div>
								<div class="form-group col-md-2 col-sm-6 col-xs-12 mt-4">
									<button type="button" class="btn btn-dark btn-lg btn-block btn-sm border border-dark " onclick="javascript:filtrar();">Filtrar</button>
								</div>
								<div class="form-group col-md-2 col-sm-6 col-xs-12 mt-4">
									<button type="button" class="btn btn-dark btn-lg btn-block btn-sm border border-dark" onclick="bajarNomina()">Descargar Nomina</button>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="card">
					<div class="card-header cssMenuSistema text-left">
						registros
					</div>
				</div>
				<div class="table-responsive">
					<table id="Compras" style="width:100%" class=" table table-borderless text-center table-hover display nowrap">
						<!--<table id="Ventas" style="width:100%" class="display nowrap">-->
						<thead class="thead-dark">
							<tr align="center">
								<th>DESCRIPCION</th>
								<th>CODIGO PLU</th>
								<th>CODIGO BARRAS</th>
								<th>VALOR</th>
								<th>STOCK</th>
								<th>CATEGORIA</th>
								<th>UNIDAD DE MEDIDA</th>
								<th>ESTADO</th>
							</tr>
						</thead>
						<?php
						if ($intTotalProductos >= 1) {
							$contador = 0;
							for ($j = 0; $j < $intTotalProductos; $j++) {

								$contador++;
								$productoId			= $arrProductos[$j][$constProductoId];
								$DescripcionProd   	= $arrProductos[$j][$constDescripcion];
								$CodigoPLU   		= $arrProductos[$j][$constCodigoPLU];
								$CodigoBarras   	= $arrProductos[$j][$constCodigoBarra];
								$ValorProducto   	= $arrProductos[$j][$constValor];
								$StockProducto   	= $arrProductos[$j][$constStock];
								$CategoriaProd   	= $arrProductos[$j][$constCategoria];
								$TipoUnidad   		= $arrProductos[$j][$constUnidad];
								$EstaActivo			= $arrProductos[$j][$constEstaActivo];
								if ($EstaActivo == 1) {
									$estado = "Activo";
								} else {
									$estado = "No Activo";
								}
								$url      = "frmProducto.php?productoId=" . $productoId . "&argAccion=editar";

								if (strlen($DescripcionProd) > 40) {
									$DescripcionProd = substr($DescripcionProd, 0, 35) . '...';
								}


								echo "<tr>"; ?>
								<td style="padding-left:30px;border-right:solid 1px #FFFFFF;" class="text-left text-truncate"><a href="<?php echo $url ?>"> <?php echo utf8_decode($DescripcionProd) ?></a></td>
						<?php
								echo "  <td>" . $CodigoPLU . "</td>";
								echo "  <td>" . $CodigoBarras . "</td>";
								echo "  <td>" . $ValorProducto . "</td>";
								echo "  <td>" . floatval($StockProducto) . "</td>";
								echo "  <td>" . $CategoriaProd . "</td>";
								if ($TipoUnidad == 1) {
									$txtUnidad = "Gramos";
								} elseif ($TipoUnidad == 2) {
									$txtUnidad = "Unidad";
								}
								echo "  <td>" . $txtUnidad . "</td>";
								echo "  <td>" . $estado . "</td>";
								echo "</tr>";
							}
						}
						?>
					</table>
				</div>
				<div>
					<div class="d-flex justify-content-start flex-wrap">
						<div class="col-12 col-md-3 col-lg-2 px-0 mx-0 mb-2">
							<button type="button" class="btn btn-danger btn-lg btn-block btn-sm border border-danger " onclick="onClickVolver();">Volver</button>
						</div>
						<div class="ml-3">
						</div>
						<div class="col-12 col-md-3 col-lg-2 px-0 mx-0 mb-2">
							<button type="button" class="btn btn-dark btn-lg btn-block btn-sm border border-dark " onclick="nuevo();">Nuevo Producto</button>
						</div>
						<div class="col-12 col-md-3 col-lg-2 px-0 mx-0 mb-2" style="margin-left: auto!important;">
							<button type="button" class="btn btn-dark btn-lg btn-block btn-sm border border-dark " onclick="onClickActualizar();">Actualizar stock rapido</button>
						</div>
					</div>



				</div>
				<a href="#" id="toTopBtn" class="cd-top text-replace js-cd-top cd-top--is-visible cd-top--fade-out" data-abc="true"></a>

			</div>
		</div>
		<br>
		<? require_once('footer.php'); ?>
	</div>
	<script>
		$(document).ready(function() {
			if ($(this).scrollTop() == 0) {
				$('#toTopBtn').fadeOut();
			}

			$('#Compras').DataTable({
				'paging': true,
				'lengthChange': true,
				'searching': true,
				'ordering': true,
				'colReorder': false,
				'processing': true,

				'responsive': {
					details: {
						display: $.fn.dataTable.Responsive.display.modal({
							header: function(row) {
								var data = row.data();
								return 'DETALLE DE LA COMPRAS ' + data[0];
							}
						}),
						renderer: $.fn.dataTable.Responsive.renderer.tableAll({
							tableClass: 'table'
						})
					}
				},
				"language": es,
				"order": [
					[0, "desc"]
				],
				"sDom": '<"top-datatables"li>rt<"bottom"p <"total-dataTables">><"clear">',
				'columnDefs': [

					{
						targets: 3,
						type: 'formatted-num',
						render: $.fn.dataTable.render.number('.', '.', 0, '$')
					},
					{
						targets: 4,
						type: 'formatted-num'
					}
				]

			});


			$("div.total-dataTables").html('Cantidad de Productos: ' + <? echo $intTotalProductos ?>);
			$("div.total-dataTables").addClass('col-12 col-md-5 col-sm-12 text-lg-right text-center text-uppercase');
			$("div.dataTables_paginate").addClass('col-12 col-md-7 col-sm-12 ');
			$("div.dataTables_info").addClass('text-uppercase');

			$("div.bottom").addClass('d-flex flex-wrap justify-content-between');
			$("div.top-datatables").addClass('d-flex flex-wrap');

			$("div.dataTables_length").addClass('text-lg-right text-center text-uppercase');
			$("div.dataTables_info ").addClass('text-lg-left text-center');



			$(window).scroll(function() {

				if ($(this).scrollTop() > 20) {
					$('#toTopBtn').fadeIn();
				} else {
					$('#toTopBtn').fadeOut();
				}
			});

			$('#toTopBtn').click(function() {
				$("html, body").animate({
					scrollTop: 0
				}, 1000);
				return false;
			});

		});
	</script>
	</body>

</HTML>