<?php

// Establece la duración de la sesión
define('DURACION_SESION', '18000'); // 2 horas
ini_set("session.cookie_lifetime", DURACION_SESION);
ini_set("session.gc_maxlifetime", DURACION_SESION);
ini_set("session.save_path", "/tmp");
session_cache_expire(DURACION_SESION);
session_start();
session_regenerate_id(true);
require_once("common/constantes.php");
require_once("dbSelectProductos.php");

//### IM : Nueva Gestion de Permisos
global $boolEsManager;
$boolEsManager = false;
$perfilId = $_SESSION['idPerfil'];
if ($perfilId == 1) {
    $boolEsManager = true;
}
if (empty($perfilId)) {
    echo "<script>top.location.href='login.php';</script>";
    exit; // Termina la ejecución del script después de redirigir
}
//### IM : Nueva Gestion de Permisos

error_reporting(E_ALL & ~E_NOTICE);
ini_set('display_errors', '1');

$txtCodigo = $_POST['txtCodigo'];
$cmbStock = $_POST['cmbStock'];
$cmbCategoriaBuscar = $_POST['cmbCategoriaBuscar'];
$cmbEstado = $_POST['cmbEstado'];

$arrProductos = select_Productos_filtro($txtCodigo, $cmbStock, $cmbCategoriaBuscar, $cmbEstado);

// Define el orden de las columnas en el archivo CSV basado en tu consulta SQL
$columnOrder = array(
    "productoId",
    "codigoPLU",
    "codigoBarra",
    "descripcion",
    "valor",
    "valorDescuento",
    "valorFinal",
    "categoria",
    "observaciones",
    "stock",
    "stockMinimo",
    "unidadMedidaId",
    "estaActivo"
);
// Inicializa un arreglo para almacenar los datos del CSV
$csvData = array();

// Agrega la fila de encabezados al arreglo en el orden especificado
$header = array();
foreach ($columnOrder as $columnName) {
    $header[$columnName] = $columnName;
}
$csvData[] = $header;

// Recorre $arrProductos y agrega cada fila como un objeto al arreglo
foreach ($arrProductos as $producto) {
    $row = array();
    foreach ($columnOrder as $columnName) {
        $row[$columnName] = $producto[$columnName];
    }
    $csvData[] = $row;
}

// Devuelve el arreglo como una respuesta JSON
echo json_encode($csvData, JSON_PRETTY_PRINT);

// Termina el script
exit;
