<?php
define('DURACION_SESION','18000'); //2 horas
ini_set("session.cookie_lifetime",DURACION_SESION);
ini_set("session.gc_maxlifetime",DURACION_SESION); 
ini_set("session.save_path","/tmp");
session_cache_expire(DURACION_SESION);
session_start();
session_regenerate_id(true); 
?>
<?php require_once("dbInsertProductos.php"); ?>
<?php require_once("dbSelectProductos.php"); ?>
<?php require_once("dbSelectFormaPago.php"); ?>
<?php require_once("dbSelectClientes.php"); ?>
<?php require_once("dbSelectVentas.php"); ?>
<?php require_once("dbInsertVentas.php"); ?>
<?php require_once("dbInsertVentaDetalles.php"); ?>
<?php require_once("dbSelectVentaDetalles.php"); ?>

<?php require_once("dbSelectProveedores.php"); ?>

<?php require_once("dbSelectCompras.php"); ?>
<?php require_once("dbSelectCompraDetalles.php"); ?>

<?php require_once("dbInsertCompras.php"); ?>
<?php require_once("dbInsertCompraDetalles.php"); ?>
<?php require_once("common/notificacionSistema.php"); ?>
<?php require_once("funciones.php"); ?>


<?php require_once("dbInsertLotes.php"); ?>
<?php require_once("dbSelectLotes.php"); ?>


<?php
global $argAccion, $mensajeError, $intCompraId;

//### IM : Nueva Gestion de Permisos
global $boolEsManager;
$boolEsManager = false;
$perfilId = $_SESSION['idPerfil'];
if ($perfilId == 1) {
	$boolEsManager = True;
}
if ($perfilId == "") {
	echo "<script>alert('Se debe ingresar con usuario y password');</script>";
	echo "<script>top.location.href='login.php';</script>";
}
//### IM : Nueva Gestion de Permisos

//asi se recupera un parametro por URL
$argAccion  = $_REQUEST['argAccion'];
$intCompraId = $_REQUEST['intCompraId'];
$intProveedorId = $_REQUEST['txtProveedorId'];

if ($argAccion == "nuevo" || $argAccion == "") {
	$argAccion = "nuevo";
	$intProveedorId  = "";
}

$txtFechaFactura = date('Y-m-d');

Global	$txtFecha,$intMontoTotal,$intMontoNeto,$intIva;
Global 	$txtProveedor,$txtRut,$txtFono, $txtNumeroFactura, $intTotalCompraDetalles;




if ($argAccion == "mostrar" || $argAccion == "anular") {
	// $intCompraId = $_REQUEST['intCompraId'];

	if (empty($intCompraId)) {
		$intCompraId = 0;
		// echo "venia vacio";
	}else{
		// echo "no venia vacio";
	}

	//LISTA DE COMPRA
	$arrCompras = select_Compra($intCompraId);

	$constCompraId 			= 0;
	$constProveedorId 		= 1;
	$constFecha				= 2;
	$constMontoTotal		= 3;
	$constMontoNeto			= 4;
	$constIva				= 5;
	$constHora				= 6;
	$constCargoExtra		= 7;
	$constObservaciones		= 8;
	$constFechaFactura		= 9;
	$constNumeroFacura		= 10;
	$constDescuento			= 11;
	$constCompraEstadoId			= 12;

	$j						= 0;

	$intTotalCompras = count($arrCompras);

	$txtVentaId 				= $arrCompras[$j][$constCompraId];
	$intProveedorId 			= $arrCompras[$j][$constProveedorId];
	$txtFecha 					= $arrCompras[$j][$constFecha];
	$intMontoTotal				= $arrCompras[$j][$constMontoTotal];
	$intMontoNeto 				= $arrCompras[$j][$constMontoNeto];
	$intIva						= $arrCompras[$j][$constIva];
	$txtHora					= $arrCompras[$j][$constHora];
	$txtCargoExtra				= $arrCompras[$j][$constCargoExtra];
	$txtObservaciones			= $arrCompras[$j][$constObservaciones];
	$txtFechaFactura			= $arrCompras[$j][$constFechaFactura];
	$txtNumeroFactura			= $arrCompras[$j][$constNumeroFacura];
	$txtDescuentoFactura		= $arrCompras[$j][$constDescuento];
	$txtCompraEstadoId			= $arrCompras[$j][$constCompraEstadoId];

	//LISTA DE COMPRA DETALLE
	$arrCompraDetalles = select_CompraDetalle($intCompraId);


	$constVentaDetalleId 		= 0;
	$constCodigoBarra 			= 1;
	$constValor					= 2;
	$constCantidad				= 3;
	$constProductoNombre		= 4;
	$constStock					= 5;
	$constValorTotal			= 6;
	$constProductoId			= 7;
	$constDescuento				= 9;

	$intTotalCompraDetalles = count($arrCompraDetalles);

	//SELECCION DE CLIENTE
	$arrProveedor = select_proveedor($intProveedorId);
	$constProveedorId = 0;
	$constNombre = 1;
	$constRut = 2;
	$constFono = 3;
	$constEmail = 6;
	$constDireccion = 8;

	$j = 0;

	$txtProveedor = $arrProveedor[$j][$constNombre];
	$txtRut  = $arrProveedor[$j][$constRut];
	$txtFono    = $arrProveedor[$j][$constFono];
}

if ($argAccion == "anular") {
	//ESTADO ANULADO
	$compraEstadoId = 3;

	if ($txtCompraEstadoId == 2) {
		for ($j = 0; $j < $intTotalCompraDetalles; $j++) {

			$productoId  = $arrCompraDetalles[$j][$constProductoId];
			$cantidad  = $arrCompraDetalles[$j][$constCantidad];
			$operacion = '-';
			update_ProductoStock($productoId, $cantidad, $operacion);
		}

		update_CompraEstado($intCompraId, $compraEstadoId);
	}
}



if ($argAccion == "grabar") {

	$txtCarroCompras = $_REQUEST['arrProductos'];
	$txtCargoExtra = $_REQUEST['txtCargo'];
	$txtObservaciones = $_REQUEST['txtObservaciones'];
	$txtFechaFactura = $_REQUEST['txtFechaFactura'];
	$txtNumeroFactura = $_REQUEST['txtNumeroFactura'];


	$arrCarro = json_decode($txtCarroCompras);
	$constProductoId = 0;
	$constCantidad 	 = 1;
	$constDescuento  = 2;
	$constPrecio	 = 3;
	$constVencimiento = 4;
	$constCodigo	 = 5;

	$intTotalCarro =  count($arrCarro);

	//VARIABLES PARA INGRESAR VENTA
	$fecha = date("Y-m-d");
	$hora = date("H:i:s");

	$montoNeto = 0;
	$montoTotal = 0;
	$iva = 0;
	$cargoExtra = 0;
	$montoDescuento = 0;
	$compraEstadoId = 2; //estado id 2 = compra finalizada

	insert_Compra($compraId, $intProveedorId, $montoTotal, $fecha, $hora, $montoNeto, $iva, $cargoExtra, $montoDescuento, $txtObservaciones, $txtFechaFactura, $txtNumeroFactura, $compraEstadoId);

	$arrCompra = select_Ultima_Compra();
	$constCompraId = 		0;
	$j = 					0;
	$intCompraId = $arrCompra[0][$constCompraId];

	for ($j = 0; $j < $intTotalCarro; $j++) {
		$productoId 		  = $arrCarro[$j][$constProductoId];
		$cantidad  			  = $arrCarro[$j][$constCantidad];
		$descuentoProducto    = $arrCarro[$j][$constDescuento];
		$precioProducto	      = $arrCarro[$j][$constPrecio];
		$fechaVencimiento     = $arrCarro[$j][$constVencimiento];
		$codigoBarraNuevo	  = $arrCarro[$j][$constCodigo];


		$arrProducto =   select_Producto($productoId);

		$constProductoId =      	0;
		$constCodigoPLU =       	1;
		$constCodigoBarra =     	2;
		$constDescripcion =     	3;
		$constValor =         		4;
		$constValorDescuento =     	5;
		$constValorFinal =       	6;
		$constProductoCategoriaId = 7;
		$constObservaciones =     	8;
		$constStock =         		9;
		$constStockMinimo =     	10;
		$constUnidadMedidaId =     	11;
		$constEstaActivo =       	12;

		$precioNeto = $arrCarro[$j][$constPrecio];

		$montoNetoProducto =  ($precioNeto * $cantidad);
		echo "<script> console.log(". $montoNetoProducto.");</script>";
		$montoDescuentoProducto = ($montoNetoProducto * ($descuentoProducto / 100));

		$montoDescuento = $montoDescuento + $montoDescuentoProducto;
		$montoFinalProducto = $montoNetoProducto - $montoDescuentoProducto;

		$montoNeto = $montoNeto + $montoNetoProducto;
		$montoTotal = $montoTotal + $montoFinalProducto;


		$operacion = '+';
		$observacion = 'N/A';

		insert_CompraDetalle($compraDetalleId, $productoId, $cantidad, $precioNeto, $descuentoProducto, $montoFinalProducto, $observacion, $intCompraId);

		$loteId = 0;
		$estaEstandar = 1;
		insert_Lote($loteId, $fecha, $fechaVencimiento, $intCompraId, 0, $cantidad, $codigoBarraNuevo, $productoId, $$observacion, $estaEstandar);

		select_Lote_Por_Producto($productoId);

		update_ProductoStock($productoId, $cantidad, $operacion);
	}

	$iva = ($montoTotal * 0.19);

	if ($txtCargoExtra > 0) {
		$cargoExtra = ($montoTotal * ($txtCargoExtra / 100));
	}

	$montoTotal = ($montoTotal * 1.19) + $cargoExtra;

	insert_Compra($intCompraId, $proveedorId, $montoTotal, $fecha, $hora, $montoNeto, $iva, $cargoExtra, $montoDescuento, $observaciones, $txtFechaFactura, $txtNumeroFactura, $compraEstadoId);

}

$arrUltimaCompra = select_Ultima_Compra();
$constCompraId = 		0;
$j = 					0;
$intUltimaCompraId = $arrUltimaCompra[$j][$constCompraId];

?>
<html>

<head>

	<title><?php echo $gen_nombreSitio; ?></title>
	<meta http-equiv="Content-Type" content="text/html;" />
	<link href="css/template_css.css" rel="stylesheet" type="text/css" />
	<link href="css/estilo.css" rel="stylesheet" type="text/css" />
	<LINK href="css/calendar-win2k-1.css" rel="stylesheet" type="text/css">
	<link rel="stylesheet" href="css/venta.css">
	<SCRIPT src="js/calendar.js"></SCRIPT>
	<SCRIPT src="js/calendar-es-CL.js"></SCRIPT>
	<SCRIPT src="js/ValidaRut.js"></SCRIPT>
	<SCRIPT src="js/validacion.js"></SCRIPT>
	<!-- BootStrap -->
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" />

	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

	<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
	<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" />

	<script src="https://code.jquery.com/ui/1.13.0/jquery-ui.js"></script>
	<script type="module" src="js/buscarProductos.js"></script>
	<script type="module" src="js/buscarProveedor.js"></script>

	<script type="text/javascript">
		//TOAST | "mensajesDisponibles" es la cantidad de mensajes que puede tener en pantalla.
		var id = 0;
		var mensajesDisponibles = [false, false, false];
		var contenidoMensaje = [];
		var espera = 0;

		//CARRO DE COMPRAS
		var arrCarritoCompras = [];
		var posicion = 0;

		//requerido para poder actualizar el precio dentro del carrito de compras y el total.
		var precioTotalFinal = []

		//TIPO DE PAGO
		var saldoTotal = [0, 0, 0, 0, 0];


		//SELECT TIPO DE PAGO
		var opcionAnterior = -1;

		$(document).ready(function() {

			<?php
			if ($argAccion == "anular") {
				echo "$('#modal-principal').modal('show');";
			}
			if ($argAccion == "grabar") {
				echo "$('#ventaCompleta').modal('show');";
			}
			?>

			$('#txtbuscarProducto').focus();

			$('#modal-principal').on('shown.bs.modal', function() {
				const input = document.querySelector('#txtCargo');
				$('#txtCargo').focus();

			})

			//solo acepta numeros
			$("#pago").keypress(function(e) {
				if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
					return false;
				}

			});
		});

		function nuevoProveedor() {
			window.open('frmProveedor.php', '_blank');

		}

		function seleccionarDeLista(elemento) {
			var elementoPrincipal = elemento.parentElement.parentElement;
			subtotal = elementoPrincipal.querySelector('#subtotal');
			descuento = elementoPrincipal.querySelector('#descuento').value;
			cantidad = elementoPrincipal.querySelector('#cantidad').value;
			numero = elemento.parentElement.parentElement.getAttribute("name").replace('posicion_', '');
			id = elemento.parentElement.parentElement.getAttribute("id").replace('producto_', '');
			precio = elementoPrincipal.querySelector('#precio_' + numero).value /*.replaceAll('.','')*/ ;

			return {
				precio,
				subtotal,
				descuento,
				cantidad,
				numero,
				id
			};

		}

		function onChangeActualizarProductoCantidad(elemento) {
			var {
				precio,
				subtotal,
				descuento,
				cantidad,
				numero
			} = seleccionarDeLista(elemento);
			cantidad = elemento.value;
			if (cantidad == '') cantidad = 0;

			var total = calcularDescuento(precio, cantidad, descuento);

			subtotal.innerHTML = /*Math.round(total).*/ total.toLocaleString('es-CL');

			arrCarritoCompras[numero][1] = cantidad;
			precioTotalFinal[numero] = total;
		}

		function onChangeActualizarProductoPrecio(elemento) {
			var {
				precio,
				subtotal,
				descuento,
				cantidad,
				numero
			} = seleccionarDeLista(elemento);

			var precio = elemento.value;

			if (precio == '') {
				precio = 0;
				elemento.value = 0;
			}

			if (precio != 0) {
				precio = precio /*.replaceAll('.','').match(/\d/g).join("");*/
			}

			var total = calcularDescuento(precio, cantidad, descuento);
			//chek1

			subtotal.innerHTML = /*Math.round(total)*/ total.toLocaleString('es-CL');
			precioTotalFinal[numero] = total;


			arrCarritoCompras[numero][3] = precio;
			actualizarPrecioFinal();
		}


		function onChangeDescuento(elemento) {
			var {
				precio,
				subtotal,
				descuento,
				cantidad,
				numero
			} = seleccionarDeLista(elemento);

			var precioTotal = calcularDescuento(precio, cantidad, descuento);
			subtotal.innerHTML = (precioTotal).toLocaleString('es-CL');

			arrCarritoCompras[numero][2] = descuento;
			precioTotalFinal[numero] = precioTotal;
			actualizarPrecioFinal();
		}

		function calcularDescuento(precio, cantidad, descuento) {
			var subTotal = cantidad * precio;
			var total = subTotal - subTotal * (descuento / 100);
			// return Math.round(total);
			return total;
		}

		function actualizarPrecioFinal() {
			var precioFinal = document.getElementById('basket-total');
			var precioCaja = document.getElementById('txtTotal');
			var precioSubTotal = document.getElementById('basket-subtotal');
			var precioIva = document.getElementById('basket-subtotal-iva');

			var totalFinal = precioTotalFinal.reduce((a, b) => a + b, 0);

			precioFinal.innerHTML = /*Math.round*/ (totalFinal * 1.19).toLocaleString('es-CL');
			precioCaja.innerHTML = /*Math.round*/ (totalFinal * 1.19).toLocaleString('es-CL');
			precioSubTotal.innerHTML = totalFinal.toLocaleString('es-CL');
			precioIva.innerHTML = /*Math.round*/ (totalFinal * 0.19).toLocaleString('es-CL');
		}

		function onInputMaximoPermitido(stock) {
			var valorActual = stock.value;
			var valorMaximo = 9999999999;
			var valorMinimo = stock.getAttribute("min");
			var subtotal = stock.parentElement.nextSibling.nextSibling;
			var subtotalDescuento = stock.parentElement.nextSibling;
			var subtotalBuscaProducto = stock.parentElement.nextSibling.nextSibling.querySelector('#txtValorTotal');

			var subtotalId = subtotal.id;
			var subtotalDescuentoId = subtotalDescuento.id;

			if (parseInt(valorActual) > parseInt(valorMaximo) && (valorActual != "" && valorMaximo != "")) {
				stock.value = valorMaximo;
			}

			if (parseInt(valorActual) < parseInt(valorMinimo) && (valorActual != "" && valorMaximo != "")) {
				stock.value = valorMinimo;
			}

			if (subtotalId == "subtotal") {
				onChangeActualizarProductoCantidad(stock);
				actualizarPrecioFinal();
			}
			if (subtotalBuscaProducto != null) {

				calcularTotalSelecionarProducto(stock.value);
			}

			if (subtotalDescuentoId == "subtotal") {
				onChangeDescuento(stock);
			}
		}

		function onInputMaximoModal(valor) {
			var valorActual = valor.value;
			var valorMaximo = valor.getAttribute("max");
			var valorMinimo = valor.getAttribute("min");

			if (parseInt(valorActual) > parseInt(valorMaximo) && (valorActual != "" && valorMaximo != "")) {
				valor.value = valorMaximo;
			}

			if (parseInt(valorActual) < parseInt(valorMinimo) && (valorActual != "" && valorMaximo != "")) {
				valor.value = valorMinimo;
			}

		}

		function onBlurEliminarNull(valor) {
			var productoId = valor.parentElement.parentElement.id.replace("producto_", "");
			var valorActual = valor.value;
			var atributo = valor.getAttribute("id");

			if (atributo == 'cantidad') {
				if (valorActual == "") {
					valor.value = 0.1;
				}

				if (valorActual == 0) {
					valor.value = 0.1;
				}
			}

			if (atributo == 'descuento') {
				if (valorActual == "") {
					valor.value = 0;
				}

				if (valorActual == 0) {
					valor.value = 0;
				}
			}

			onInputMaximoPermitido(valor);
			actualizarPrecioFinal();

			for (var i = 0; i < arrCarritoCompras.length; i++) {
				if (arrCarritoCompras[i][0] == productoId) {
					if (atributo == 'cantidad') {
						arrCarritoCompras[i][1] = valor.value;
					}

					if (atributo == 'descuento') {
						arrCarritoCompras[i][2] = valor.value;

					}


				}
			}
		}

		function onBlurEliminarNullSelecionarProducto(valor) {
			var valorActual = valor.value;

			if (valorActual == "") {
				valor.value = 0.1;
				calcularTotalSelecionarProducto(valor.value);
			}

			if (valorActual == 0) {
				valor.value = 0.1;
				calcularTotalSelecionarProducto(valor.value);
			}
		}

		function onChangeVencimiento(elemento) {
			var {
				precio,
				subtotal,
				descuento,
				cantidad,
				numero
			} = seleccionarDeLista(elemento);
			arrCarritoCompras[numero][4] = elemento.value;

		}

		function onChangeCodigoBarra(elemento) {
			var {
				precio,
				subtotal,
				descuento,
				cantidad,
				numero
			} = seleccionarDeLista(elemento);
			arrCarritoCompras[numero][5] = elemento.value;

		}


		productoId = 1;

		function carritoCompras(productoId_, codigoBarra, nombre, precio, cantidad, stock, descuento) {



			var desc = /*Math.round*/(((precio * cantidad) * descuento) / 100);

			var htmlProducto = "";
			htmlProducto = htmlProducto + '<tr style="" name="posicion_' + posicion + '" id="producto_' + productoId + '">';

			htmlProducto = htmlProducto + '<td>';
			htmlProducto = htmlProducto + '<input type="text" class="cssInputCorto bg-white" onChange="onChangeCodigoBarra(this)"  id="codigo_' + posicion + '">';
			htmlProducto = htmlProducto + '</td>';

			htmlProducto = htmlProducto + '<td>';
			htmlProducto = htmlProducto + '<input type="text" class="cssInputMedio bg-white" style="width:170px" disabled value="' + nombre + ' ">';
			htmlProducto = htmlProducto + '</td>';
			htmlProducto = htmlProducto + '<td>';
			htmlProducto = htmlProducto + '<input type="date" onchange="onChangeVencimiento(this)" style="width:170px" class="cssInputCorto bg-white" >';
			htmlProducto = htmlProducto + '</td>';
			<?php if ($argAccion == "nuevo" || $argAccion == "grabar") { ?>
				htmlProducto = htmlProducto + '<td> ';
				htmlProducto = htmlProducto + '<input type="text"  onClick="this.select();"  class="cssInputCorto bg-white" oninput="onChangeActualizarProductoPrecio(this);onInputMaximoPermitido(this);onInputFormatoNumeros(this.value,' + "'precio_" + posicion + "'" + ')" onBlur="onBlurEliminarNull(this)"  onChange="onChangeActualizarProductoPrecio(this);" id="precio_' + posicion + '" value="' + new Intl.NumberFormat('es-CL').format(precio) + '">';
				htmlProducto = htmlProducto + '</td>';
			<? } else { ?>
				htmlProducto = htmlProducto + '<td> ';
				htmlProducto = htmlProducto + '<input type="text"  onClick="this.select();" disabled  class="cssInputCorto bg-white" oninput="onChangeActualizarProductoPrecio(this);onInputMaximoPermitido(this);onInputFormatoNumeros(this.value,' + "'precio_" + posicion + "'" + ')" onBlur="onBlurEliminarNull(this)"  onChange="onChangeActualizarProductoPrecio(this);" id="precio_' + posicion + '" value="' + new Intl.NumberFormat('es-CL').format(precio) + '">';
				htmlProducto = htmlProducto + '</td>';
			<? } ?>
			htmlProducto = htmlProducto + '<td>';
			<?php if ($argAccion == "nuevo" || $argAccion == "grabar") { ?>
				htmlProducto = htmlProducto + '<input type="number" class="cssInputCorto bg-white" oninput="onInputMaximoPermitido(this)" onBlur="onBlurEliminarNull(this)"  onChange="onChangeActualizarProductoCantidad(this);" id="cantidad" value="' + cantidad + '" min="0" max = "' + stock + '">';
			<? } else { ?>
				htmlProducto = htmlProducto + '<input type="number" disabled class=" cssInputCortobg-white" oninput="onInputMaximoPermitido(this)" onBlur="onBlurEliminarNull(this)"  onChange="onChangeActualizarProductoCantidad(this);" id="cantidad" value="' + cantidad + '" min="0" max = "' + stock + '">';
				htmlProducto = htmlProducto + ' </td>';
				htmlProducto = htmlProducto + '<td>';
				htmlProducto = htmlProducto + '<input type="number" disabled class="cssInputCorto bg-white" oninput="onInputMaximoPermitido(this)" onBlur="onBlurEliminarNull(this)" onChange="onChangeDescuento(this)" id="descuento" value="' + descuento + '" min="0" max = "26">';
				htmlProducto = htmlProducto + '<div class="input-group-append">';
				htmlProducto = htmlProducto + '<span class="bg-white">%</span>';
				htmlProducto = htmlProducto + ' </div>';

			<? } ?>
			htmlProducto = htmlProducto + ' </td>';

			<?php if ($argAccion == "nuevo" || $argAccion == "grabar") { ?>

				htmlProducto = htmlProducto + '<td>';
				htmlProducto = htmlProducto + '<input type="number" class="cssInputCorto bg-white descuento" style="width:80%" oninput="onInputMaximoPermitido(this)" onBlur="onBlurEliminarNull(this)" onChange="onChangeDescuento(this)" id="descuento" value="0" min="0" max = "26">';
				htmlProducto = htmlProducto + '<div class="input-group-append">';
				htmlProducto = htmlProducto + '<span class="input-group-text m-0 p-0 bg-white" style="border: 0px solid #ced4da!important;">%</span>';
				htmlProducto = htmlProducto + ' </div>';

				htmlProducto = htmlProducto + ' </td>';
			<? } ?>

			htmlProducto = htmlProducto + '<td id="subtotal"> ' + /*Math.round*/ (precio * cantidad - desc).toLocaleString('es-CL') + ' </td>';


			<?php if ($argAccion == "nuevo") { ?>
				htmlProducto = htmlProducto + '<td onClick="eliminarProducto(this)" >  <button class="btn btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></button></td>';
			<? } ?>

			htmlProducto = htmlProducto + '</tr>';

			//

			posicion++;
			productoId = productoId + 2;
			//

			//se almacena en el carro de compras el producto y la cantidad.
			arrCarritoCompras.push([productoId_, cantidad, '0', precio, 0, 0]);
			precioTotalFinal.push( /*Math.round*/ (precio * cantidad) - desc);

			//se muestra el producto agregado al carro de compras.
			$("#resultado").append(htmlProducto);
			//var $nueva = $("#producto_"+productoId);
			//animación.
			//$nueva.show(400);


			<?php if ($argAccion == "nuevo") { ?>
				//resetea los valores a los originales.
				document.getElementById('txtbuscarProducto').value = '';
				document.getElementById('txtbuscarProducto').focus();

				document.getElementById('txtCodigobarra').value = '';
				document.getElementById('txtNombreProducto').value = '';
				document.getElementById('txtPrecio').value = '';
				document.getElementById('txtValorTotal').value = '';
				document.getElementById("txtCantidad").value = '';
				document.getElementById('txtCantidad').setAttribute('max', 0);
				document.getElementById("txtCantidad").setAttribute("disabled", "disabled");
				document.getElementById("txtCantidad").classList.remove("cssInputFechaFiltro");

				$('#sugerenciasProductos').fadeOut(10);

				//se actualiza el valor total
				actualizarPrecioFinal();


			<?php } ?>
		}

		//se eliminan los productos con ID 0, para no afecte al insert de datos.
		function filtrarEliminados() {
			for (var i = 0; i < arrCarritoCompras.length; i++) {

				if (arrCarritoCompras[i][0] == 0) {
					arrCarritoCompras.splice(i, 1);
				}
			}

		}

		function eliminarProducto(elemento) {

			var {
				precio,
				subtotal,
				descuento,
				cantidad,
				numero,
				id
			} = seleccionarDeLista(elemento.children[0]);

			//buscar y deja en 0 el producto del array, con el objectivo de simular estar eliminado
			for (var i = 0; i < arrCarritoCompras.length; i++) {
				if (arrCarritoCompras[i][0] == id) {
					arrCarritoCompras[i][0] = 0;
					arrCarritoCompras[i][1] = 0;
					arrCarritoCompras[i][2] = 0;
					arrCarritoCompras[i][3] = 0;

					break;
				}
			}

			//buscar el div del producto
			var producto = document.getElementById('producto_' + id);

			precioTotalFinal[numero] = 0;

			actualizarPrecioFinal();

			//elimina el elemento
			producto.remove();

		}

		function agregarProducto() {
			var valida = false;

			if (document.frmCompra.txtCodigobarra.value == "") {
				valida = true;
			}

			//  alert(document.frmCompra.txtCodigobarra.value)

			if (valida) {
				generarToast(<? echo $notificacion->PRODUCTO_NO_BUSCADO ?>)
				return false;
			}

			//se extraen los valores del buscador de productos.
			var productoId = $('#txtProductoId').val();
			var codigoBarra = $('#txtCodigobarra').val();
			var nombreProducto = $('#txtNombreProducto').val();
			var precioProducto = $('#txtPrecio').val().replaceAll(".", "");
			var cantidadProducto = $('#txtCantidad').val();
			var cantidadStock = $('#txtCantidad').attr('max');

			if (!cantidadProducto || cantidadProducto == 0) cantidadProducto = 1;

			carritoCompras(productoId, codigoBarra, nombreProducto, precioProducto, cantidadProducto, cantidadStock, 0);

		}

		function calcularTotalSelecionarProducto(value) {
			var precio = document.getElementById('txtPrecio').value.replaceAll(".", "");
			document.getElementById('txtValorTotal').value = (precio * value).toLocaleString('es-CL');
		}

		async function onClickGuardar() {
			var valida = false;
			precio = precioTotalFinal.reduce((a, b) => a + b, 0);

			if (saldoTotal.reduce((a, b) => a + b, 0) > 0) {
				onInputCalcularSaldo(0, 'ninguno');
			} else {
				document.getElementById('txtSaldo').innerHTML = /*Math.round*/ (precio * 1.19).toLocaleString('es-CL');
			}

			if (document.frmCompra.txtProveedor.value == '') {
				return generarToast("Debe seleccionar un proveedor");
			}

			if (document.frmCompra.txtFechaFactura.value == '') {
				return generarToast("Debe una fecha valida");

			}

			if (document.frmCompra.txtNumeroFactura.value == '') {
				return generarToast("Debe ingresar un numero de factura");

			}



			if (precioTotalFinal.reduce((a, b) => a + b, 0) == 0) {
				return generarToast(<? echo $notificacion->PRODUCTO_NO_SELECCIONADO ?>);
			};

			await $("#modal-principal").modal("show");

		}

		function onClickConfirmar() {
			$("#modal-principal").modal("show");

		}

		function onClickVolver() {
			document.frmCompra.action = "vwAdministracion.php";
			document.frmCompra.submit();
		}

		function onClickFinalizarProceso() {
			var valida = false;




			filtrarEliminados();

			document.frmCompra.action = "frmCompra.php";
			document.frmCompra.argAccion.value = "grabar";
			document.frmCompra.arrProductos.value = JSON.stringify(arrCarritoCompras);

			setTimeout(document.frmCompra.submit(), 1000);

		}

		function onClickAnularVenta() {
			document.frmCompra.action = "frmCompra.php";
			document.frmCompra.argAccion.value = "anular";
			document.frmCompra.submit();
		}

		async function generarToast(mensaje) {

			//busca posición disponible en pantalla
			var posicionDisponible = mensajesDisponibles.indexOf(false);

			//si no existe se agrega a la cola.
			if (posicionDisponible == -1) return esperaToast(mensaje);

			var toasts = new toast(mensaje, posicionDisponible);

			mensajesDisponibles[posicionDisponible] = true;

			$('#toast_').prepend(toasts.getContenido());

			toasts.eliminar();
		}

		//lista de toast pendientes. se almacenan todos para ir mostrando en pantalla en orden.
		function esperaToast(mensaje) {
			contenidoMensaje.push(mensaje);
			espera++;
		}

		//Los toast son objetos, cada uno con su id.
		function toast(mensaje, posicion) {
			this.posicion = posicion;
			this.tipo = 'Alerta';
			this.mensaje = mensaje;
			this.numero = 0;
			//duracion en segundos.
			this.duracion = 2;
			this.contenido = '';
			this.lugar = posicion == 0 ? 4 : 4 + (posicion * 6);

			this.getNumero = function() {
				return this.numero;
			}

			this.getLugar = function() {
				return this.lugar;
			}

			this.getDuracion = function() {
				return this.duracion;
			}

			this.getPosicion = function() {
				return this.posicion;

			}

			this.setNumero = function() {
				this.numero = id;
			}

			this.getTipo = function() {
				return this.tipo;
			}

			this.getContenido = function() {
				this.setNumero();
				//contenido completo del toast
				this.contenido = this.contenido + '<div  id="toast_alert_' + this.getNumero() + '" name="toast_alert" class="toast bg-light animacion-toast border border-dark rounded-0" style="opacity:1; top: ' + this.getLugar() + 'rem; " role="alert" aria-live="assertive" aria-atomic="true">';
				this.contenido = this.contenido + '  <div class="toast-header bg-danger rounded-0 ">';
				this.contenido = this.contenido + '	<strong class="mr-auto text-light text-uppercase " >' + this.getTipo() + '</strong>';
				this.contenido = this.contenido + '<button type="button" class="ml-2 mb-1 close text-white" data-dismiss="toast" aria-label="Close">';
				//	this.contenido = this.contenido + '<span aria-hidden="true">&times;</span>';
				this.contenido = this.contenido + '</button>';
				this.contenido = this.contenido + '</div>';
				this.contenido = this.contenido + '<div class="toast-body detalle">';
				this.contenido = this.contenido + this.mensaje;
				this.contenido = this.contenido + '</div>';
				this.contenido = this.contenido + '</div>';

				id++;

				return this.contenido;
			}

			//eliminar y modificar los toast en caso de que exista mas de 1.
			this.eliminar = function() {
				//eliminación del toast.
				setTimeout(() => {
					//animación de mover a la izquierda.
					$("#toast_alert_" + this.getNumero()).addClass('animacion-eliminar');
					setTimeout(() => {

						mensajesDisponibles[this.getPosicion()] = false;
						//revisa si hay toast en espera para mostrar el siguiente una vez que finalice uno.
						if (espera > 0) {
							espera--;
							generarToast(contenidoMensaje.shift());
						}
						//eliminarlo por completo.
						document.getElementById("toast_alert_" + this.getNumero()).remove();
					}, 900);

				}, (this.getDuracion() * 1000) + 1000);
			};
		}


		function onInputCalcularSaldo(valor, tipo) {
			var precio = precioTotalFinal.reduce((a, b) => a + b, 0);

			if (parseInt(valor) > 50) valor = 50;
			if (valor == 0) valor = 0;
			saldoTotal[0] = valor;
			document.getElementById('txtCargo').value = valor;
			document.getElementById('txtSaldo').innerHTML = /*Math.round*/ (precio * 1.19 + /*Math.round*/ ((precio * valor) / 100)).toLocaleString('es-CL');

		}

		function onInputFormatoNumeros(valor, elemento) {
			var div = document.getElementById(elemento);
			if (valor == '') {
				valor = 0;
			} else {
				valor = valor.replaceAll(',', '.');
			}


			// div.value = parseFloat(valor).toLocaleString('es-CL');
		}

		function onClickReset() {
			document.getElementsByName("frmCompra")[0].reset();
			document.frmCompra.action = "frmCompra.php";
			document.frmCompra.argAccion.value = "nuevo";

			setTimeout(document.frmCompra.submit(), 700);


		}
	</script>
</head>

<body>
	<form name="frmCompra" method="post" onsubmit="return false;">
		<input type="hidden" name="argAccion" value="<?php echo $argAccion; ?>">
		<input type="hidden" name="intCompraId" value="<?php echo $intCompraId; ?>">
		<input type="hidden" name="arrProductos" value="">
		<input type="hidden" name="txtfrmCompra" value="1">

		<div id="pagina">
			<div id="cabecera">
				<?php require_once("menuDefinicion.php"); ?>
			</div>
			<div id="contenido">
				<div class="container-fluid overflow-auto" style="width : 95%;">
					<p class="cssMenuSistema list-group-item  lista-item text-center active h5 text-uppercase" data-remote="true" href="#" id="categoria_0">
						<? if ($argAccion == 'nuevo' || $argAccion == "grabar") echo 'Compra de Productos'; ?>
						<? if ($argAccion == 'anular' || $argAccion == 'mostrar') echo 'Detalle de Compra'; ?>

					</p>
					<tr>
						<!---TOAST-->
						<div id="toast_" style="position: absolute; top: 4rem;right: 1rem;z-index:99; ">
						</div>
						<!---FINAL  TOAST-->


						<!--PRECIOS -->
						<aside>
							<div class="muestraPrecios card bg-light  border-dark mb-3">
								<div class="card-header cssMenuSistema text-center text-uppercase" style="border-radius:0; margin:-1rem;">
									Resumen de Compra
								</div>
								<div class="card-body paddingDetalle">
									<?php if ($argAccion == 'nuevo' || $argAccion == 'grabar') {  ?>
										<div class="d-flex justify-content-between mt-3">

											<p class="card-text text-left mt-1 mr-3 text-uppercase detalle">Numero de Compra</p>
											<p class="card-text text-right mt-1"><?php echo $intUltimaCompraId + 1 ?> </p>
										</div>
										<div class="d-flex justify-content-between mt-0">
											<p class="card-text text-left detalle detalle">TOTAL NETO</p>
											<div class="total-value final-value" id="basket-subtotal"> <?php echo number_format($intMontoNeto, 4,',', '.') ?></div>
										</div>
										<div class="d-flex justify-content-between mt-0">
											<p class="card-text text-left detalle detalle">IVA</p>
											<div class="total-value final-value" id="basket-subtotal-iva"> <?php echo number_format($intIva, 4,',', '.') ?></div>
										</div>
										<!-- <div class="summary-total mt-5">-->
										<div class="summary-total">

										<?php } else {

										//	echo	'<div class="d-flex justify-content-between">';
										//	echo	'<p class="card-text text-left mt-1 mr-3 text-uppercase"><b>Fecha </b> </p>';
										//	echo	'<p class="card-text text-right mt-1">' .  $txtFecha . '</p>';
										//	echo	'</div>';

										echo	'<div class="d-flex justify-content-between">';
										echo	'<p class="card-text text-left mt-4 mr-3 text-uppercase detalle">Numero de Compra</p>';
										echo	'<p class="card-text text-right mt-4">' .  $txtVentaId . '</p>';
										echo	'</div>';

										echo	'<div class="d-flex justify-content-between mt-0">';
										echo	'<p class="card-text text-left detalle">TOTAL NETO</p>';
										echo	'<div class="total-value final-value" id="basket-subtotal">' .  number_format($intMontoNeto, 4,',', '.') . '</div>';
										echo	'</div>';

										if ($txtDescuentoFactura > 0) {

											echo	'<div class="d-flex justify-content-between mt-0">';
											echo	'<p class="card-text text-left detalle">DESCUENTO</p>';
											echo	'<div class="total-value final-value" id="basket-subtotal">' .  number_format($txtDescuentoFactura, 4,',', '.') . '</div>';
											echo	'</div>';
										}

										echo	'<div class="d-flex justify-content-between mt-0">';
										echo	'<p class="card-text text-left detalle">IVA</p>';
										echo	'<div class="total-value final-value" id="basket-subtotal-iva">' . number_format($intIva, 4,',', '.') . '</div>';
										echo	'</div>';

										echo	'<div class="d-flex justify-content-between mt-0">';
										echo	'<p class="card-text text-left detalle">EXTRAS</p>';
										echo	'<div class="total-value final-value" id="basket-subtotal">' .  number_format($txtCargoExtra, 4,',', '.') . '</div>';
										echo	'</div>';

										echo	'<div class="summary-total mt-0">';
									}

										?>
										<div class="total-title">TOTAL</div>
										<div class="total-value final-value" id="basket-total"> <?php echo number_format($intMontoTotal, 4,',', '.') ?></div>
										</div>
								</div>
								<?php if ($argAccion == 'nuevo' || $argAccion == 'grabar') {  ?>
									<div class="card-foooter">
										<button type="button" class="btn btn-dark btn-lg btn-block btn-sm border border-dark rounded-0" onclick="onClickGuardar()">CONTINUAR</button>
									</div>

								<?php } elseif ($txtCompraEstadoId == 2 && $argAccion == "mostrar") { ?>
									<div class="card-foooter d-flex justify-content-between">

										<div class="col-6">
											<button type="button" class="btn btn-outline-dark btn-lg btn-block btn-sm border border-dark rounded-0" onclick="onClickConfirmar()">ANULAR</button>
										</div>


										<div class="col-6">
											<button type="button" class="btn btn-dark btn-lg btn-block btn-sm border border-dark rounded-0" onclick="onClickVolver()">VOLVER</button>
										</div>
									</div>

								<?php } else {  ?>
									<div class="card-foooter">
										<button type="button" class="btn btn-dark btn-lg btn-block btn-sm border border-dark rounded-0" onclick="onClickVolver()">VOLVER</button>
									</div>
								<?php }  ?>
							</div>
						</aside>
						<!--PROVEEDOR INI-->
						<div class="card text-left marco">
							<div class="card-header cssMenuSistema text-left text-uppercase rounded-0">
								Factura
							</div>
							<div class="card-body d-flex justify-content-between p-0 pt-1">
								<div class="form-group col-2 mt-4">
									<input onfocus="this.select();" type="text" <?php if ($argAccion == "mostrar" || $argAccion == "anular")  echo 'disabled' ?> placeholder=' ' class="form-control bg-white" type="text" name="txtProveedor" value="<?php echo $txtProveedor ?>" id="txtProveedor">
									<label class="form-control-placeholder" for="txtProveedor">BUSCAR PROVEEDOR</label>
									<input type="hidden" name="txtProveedorId" id="txtProveedorId" value="<?php echo $intProveedorId ?>">
								</div>
								<div id="sugerencias"></div>

								<div class="form-group col-2 mt-4">
									<input type="text" id="txtRut" class="form-control bg-white" disabled placeholder=' ' type="text" name="txtRut" value="<?php echo $txtRut ?>">
									<label class="form-control-placeholder" for="txtRut">RUT</label>
								</div>
								<div class="form-group col-2 mt-4">
									<input type="text" id="txtFono" class="form-control bg-white" disabled placeholder=' ' type="text" name="txtFono" value="<?php echo $txtFono ?>">
									<label class="form-control-placeholder" for="txtFono">TELEFONO</label>
								</div>
								<?php if ($argAccion == "mostrar") { ?>
									<div class="form-group col-2 mt-4">
										<input type="date" id="txtFechaActual" class="form-control bg-white" disabled placeholder=' ' type="text" name="txtFechaActual" value="<?php echo $txtFecha ?>">
										<label class="form-control-placeholder" for="txtFechaActual">FECHA INGRESO </label>
									</div>
								<? } ?>

								<div class="form-group col-2 mt-4">
									<input type="date" id="txtFechaFactura" class="form-control bg-white" <?php if ($argAccion == "mostrar" || $argAccion == "anular")  echo 'disabled' ?> placeholder=' ' type="text" name="txtFechaFactura" value="<?php echo $txtFechaFactura ?>">
									<label class="form-control-placeholder" for="txtFechaFactura">FECHA FACTURA </label>
								</div>
								<div class="form-group col-2 mt-4">
									<input type="text" id="txtNumeroFactura" class="form-control bg-white" <?php if ($argAccion == "mostrar" || $argAccion == "anular")  echo 'disabled' ?> placeholder=' ' type="text" name="txtNumeroFactura" value="<?php echo $txtNumeroFactura ?>">
									<label class="form-control-placeholder" for="txtNumeroFactura">NUMERO FACTURA </label>
								</div>
								<?php if ($argAccion == 'nuevo' || $argAccion == "grabar") { ?>
									<div class="col-2">
										<div><br> </div>
										<button type="button" class="btn btn-dark btn-lg btn-block btn-sm border border-dark rounded-0" onclick="javascript:nuevoProveedor();">Nuevo Proveedor</button>
									</div>
								<? } ?>
							</div>
						</div>
						<!--GLOSA FIN-->
						<?php if (($argAccion == "mostrar" || $argAccion == "anular") && !empty($txtObservaciones)) {
						?>
							<!--PROVEEDOR INI-->
							<div class="card text-left marco">
								<div class="card-header cssMenuSistema text-left text-uppercase rounded-0">
									GLOSA
								</div>
								<div class="card-body d-flex justify-content-between p-0 pt-1">
									<div class="form-group col-12 mt-4">
										<p class="text-justify">"<?php echo $txtObservaciones ?>"</p>
									</div>
								</div>
							</div>
						<? } ?>
						<!--GLOSA FIN-->

						<!--MODAL-->
						<div tabindex="-1" class="modal pmd-modal fade text-center" id="modal-principal" style="display: none;" aria-hidden="true">
							<div class="modal-dialog">
								<div class="modal-content">
									<div class="modal-header bg-dark text-light">
										<!--REVISAR-->
										<?php if ($argAccion == "nuevo") { ?>

											<h5 class="modal-title text-uppercase">Finalizando Proceso</h5>
										<? } else { ?>
											<h5 class="modal-title text-uppercase">confirmar</h5>

										<? } ?>

										<button type="button" class="close text-light" data-dismiss="modal" aria-label="Close">
											<span aria-hidden="true">&times;</span>
										</button>
									</div>
									<div class="modal-body bg-light">
										<h2></h2>
										<?php if ($argAccion == "nuevo") { ?>

											<div class="d-flex justify-content-center mt-3">
												<div class="form-group col-6" name="efectivo">
													<p class="card-text text-left mt-1 mr-3 h3 detalle ">VALOR TOTAL</p>
												</div>
												<div class="form-group col-6 h3" name="efectivo">
													<p class="card-text text-right mt-1 cajero-value" id="txtTotal"></p>
												</div>
											</div>
											<div class="d-flex justify-content-center mb-3">
												<div class="form-group col-12 d-flex justify-content-center" name="efectivo">
													<p class="card-text text-center mt-1 detalle">DETALLE DE PAGO</p>
												</div>
											</div>
											<!--flex-column-->
											<div class="card-body d-flex flex-wrap pt-1">
												<div class="form-group col-6" name="debito" id="pago">
													<input onFocus="let value = this.value; this.value = null; this.value=value" oninput="onInputCalcularSaldo(this.value, 'debito');onInputMaximoModal(this); onInputFormatoNumeros(this.value,'txtCargo');" type="number" value="0" class="form-control bg-light col-10" placeholder=' ' type="text" name="txtCargo" id="txtCargo" min="0" max="50">
													<label class="form-control-placeholder" for="txtCargo">PORCENTAJE EXTRA</label>
													<div class="input-group-append mt-2">
														<span class="input-group-text m-0 p-0 bg-light" style="border: 0px solid #ced4da!important;font-size: 22px;">%</span>
													</div>
												</div>
											</div>
											<div></div>
											<div class="summary-total mb-4" style="border-bottom: 0px solid #ccc;">
												<div class="d-flex justify-content-between">
													<div class="form-group col-6 mb-1" name="efectivo">
														<p class="card-text text-left mt-1 mr-3 total-title">SALDO</p>
													</div>
													<div class="form-group col-6 mb-1">
														<p class="card-text text-right mt-1 cajero-value" id="txtSaldo">0</p>
													</div>
												</div>
											</div>
											<div class="form-group d-flex justify-content-center">
												<textarea class="form-control border-animation" id="txtObservaciones" rows="3" type="text" name="txtObservaciones" placeholder=" "></textarea>
												<label class="form-control-placeholder" for="txtObservaciones">GLOSA</label>
											</div>

										<? }
										if (($argAccion == 'mostrar')) { ?>
											<p class="text-uppercase">Para confirmar la anulacion de la compra presione "anular"</p>

										<? }
										if (($argAccion == 'anular')) { ?>
											<p class="text-uppercase">La Compra ha sido anulada</p>

										<? } ?>

									</div>
									<div class="modal-footer justify-content-center">

										<?php if ($argAccion == "nuevo") { ?>
											<button class="btn pmd-ripple-effect btn-dark border border-dark rounded-0" aria-hidden="true" data-dismiss="modal" class="close" type="button" onclick="onClickFinalizarProceso()">FINALIZAR PAGO</button>
											<!-- <button data-dismiss="modal"  class="btn pmd-ripple-effect btn-secondary" type="button" >GENERAR BOLETA</button> -->
											<button class="btn pmd-ripple-effect btn-danger border border-danger rounded-0" aria-hidden="true" data-dismiss="modal" class="close" type="button">CANCELAR</button>

										<?php }
										if ($argAccion == "mostrar") { ?>
											<button data-dismiss="modal" class="btn pmd-ripple-effect btn-dark border border-dark rounded-0" type="button" onclick="onClickAnularVenta()">ANULAR</button>
											<button class="btn pmd-ripple-effect btn-danger border border-danger rounded-0" aria-hidden="true" data-dismiss="modal" class="close" type="button">CANCELAR</button>

										<?php }
										if ($argAccion == "anular") {  ?>
											<button class="btn pmd-ripple-effect btn-dark border border-dark rounded-0" aria-hidden="true" data-dismiss="modal" class="close" type="button">VOLVER</button>

										<? } ?>

									</div>
								</div>
							</div>
						</div>

						<!-- MODAL FINAL VENTA INI -->
						<div tabindex="-1" class="modal pmd-modal fade text-center" id="ventaCompleta" style="display: none;" aria-hidden="true">

							<div class="modal-dialog" role="document">
								<div class="modal-content">
									<div class="modal-header bg-dark text-light">
										<h5 class="modal-title"> NOTIFICACION </h5>
									</div>
									<div class="modal-body d-flex">
										<div class="col-12">
											<div class="form-group col-10 mt-4">
												<p class="text-uppercase">La compra ha sido realizada</p>
											</div>
										</div>
									</div>
									<div class="modal-footer">
										<button type="button" class="btn btn-dark border border-dark rounded-0" aria-hidden="true" data-dismiss="modal" class="close" onclick="onClickReset();" ;>CERRAR</button>
									</div>
								</div>
							</div>
						</div>
						<!-- MODAL FINAL VENTA FIN -->


						<!--FINAL MODA-->

						<!--PRODUCTO -->
						<?php if ($argAccion == "nuevo" || $argAccion  == "grabar") {
						?>
							<div class="card text-left marco">
								<div class="card-header cssMenuSistema text-left text-uppercase" style="border-radius:0;">
									Seleccion de Producto
								</div>
								<div class="card-body d-flex justify-content-between p-0 pt-1">
									<div class="form-group col-2 mt-4">
										<input type="text" class="form-control bg-white" placeholder=' ' type="text" name="txtbuscarProducto" id="txtbuscarProducto" maxlength="13">
										<label class="form-control-placeholder" for="txtbuscarProducto">BUSCAR PRODUCTO</label>
										<input type="hidden" id="txtProductoId" name="txtProductoId" />
									</div>
									<div id="sugerenciasProductos"></div>
									<div class="form-group col-2 mt-4">
										<input type="text" class="form-control bg-white" disabled placeholder=' ' type="text" name="txtCodigobarra" id="txtCodigobarra">
										<label class="form-control-placeholder" for="txtCodigobarra">CODIGO DE BARRA</label>
									</div>
									<div class="form-group col-2 mt-4">
										<input type="text" class="form-control bg-white " disabled placeholder=' ' type="text" name="txtNombreProducto" id="txtNombreProducto">
										<label class="form-control-placeholder" for="txtNombreProducto">PRODUCTO</label>
									</div>
									<div class="form-group col-1 mt-4">
										<input type="text" class="form-control bg-white" disabled placeholder=' ' type="text" name="txtPrecio" id="txtPrecio">
										<label class="form-control-placeholder" for="txtPrecio">PRECIO</label>
									</div>
									<div class="form-group col-1 mt-4" style="max-width:12.499999995%;flex-basis:12.499999995%;">
										<input class="form-control bg-white" type="number" disabled placeholder=' ' oninput="onInputMaximoPermitido(this)" onBlur="onBlurEliminarNullSelecionarProducto(this)" min="0" max="0" name="txtCantidad" id="txtCantidad" onChange="calcularTotalSelecionarProducto(this.value)">
										<label class="form-control-placeholder" for="txtCantidad">CANTIDAD</label>
									</div>
									<div class="form-group col-1 mt-4" style="max-width:12.499999995%;flex-basis:12.499999995%;">
										<input class="form-control bg-white" type="text" disabled placeholder=' ' name="txtValorTotal" id="txtValorTotal">
										<label class="form-control-placeholder" for="txtValorTotal">TOTAL</label>
									</div>
									<div class="col-2">
										<div><br> </div>
										<button type="button" class="btn btn-dark btn-lg btn-block btn-sm text-uppercase border border-dark rounded-0" onclick="javascript:agregarProducto();">Agregar al Carro</button>
									</div>
								</div>
							</div>


						<?php } ?>



						<div class="card text-left marco">
							<div class="card-header cssMenuSistema text-left text-uppercase" style="border-radius:0;">
								Carro de Compra
							</div>
							<div class="card-body d-flex justify-content-between p-0">
								<table class="table table-borderless">
									<thead>
										<tr>
											<th scope="col" class="text-uppercase">Codigo DE BARRA</th>
											<th scope="col" style="width:30%" class="text-uppercase">Producto</th>
											<th scope="col" class="text-uppercase">FECHA VENCIMIENTO</th>

											<th scope="col" class="text-uppercase">Precio Compra Unitario/Kilo</th>
											<th scope="col" class="text-uppercase">Cantidad/Peso</th>
											<th scope="col" class="text-uppercase">Descuento</th>
											<th scope="col" class="text-uppercase">Subtotal</th>

											<?php if ($argAccion == "nuevo"  || $argAccion == "grabar") { ?>
												<th scope="col" class="text-uppercase">Accion</th>
											<? } ?>

										</tr>
									</thead>
									<tbody id="resultado">
									</tbody>
								</table>
							</div>
						</div>

				</div>
			</div>
			<?php require_once("footer.php"); ?>


		</div>
		<script>
			//CARGAR LA LISTA DE VENTAS
			<?php
			for ($j = 0; $j < $intTotalCompraDetalles; $j++) {

				$productoId = $arrCompraDetalles[$j][$constProductoId];
				$codigoBarra	 = $arrCompraDetalles[$j][$constCodigoBarra];
				$nombre = $arrCompraDetalles[$j][$constProductoNombre];
				$precio = $arrCompraDetalles[$j][$constValor];
				$cantidad = $arrCompraDetalles[$j][$constCantidad];
				$stock = $arrCompraDetalles[$j][$constStock];
				$descuento = $arrCompraDetalles[$j][$constDescuento];


				echo 'carritoCompras(' . $productoId . ',' . $codigoBarra . ',`' . $nombre . '`,' . $precio . ',' . $cantidad . ',' . $stock . ',' . $descuento . ');';
			}
			?>
		</script>

</body>

</HTML>