﻿Apex.grid = {
  padding: {
    right: 0,
    left: 0
  }
}

var toolbar= {
	show: true,
	offsetX: 0,
	offsetY: 0,
	tools: {
	  download: true,
	  selection: true,
	  zoom: true,
	  zoomin: true,
	  zoomout: true,
	  pan: true,
	  reset: true | '<img src="/static/icons/reset.png" width="20">',
	  customIcons: []
	},
	export: {
	  csv: {
		filename: undefined,
		columnDelimiter: ',',
		headerCategory: 'category',
		headerValue: 'value',
		dateFormatter(timestamp) {
		  return new Date(timestamp).toDateString()
		}
	  },
	  svg: {
		filename: undefined,
	  },
	  png: {
		filename: undefined,
	  },
	  pdf:{
		filename: undefined,

	  }
	},
	autoSelected: 'zoom' 
	}


Apex.dataLabels = {
  enabled: false
}

var randomizeArray = function (arg) {
  var array = arg.slice();
  var currentIndex = array.length, temporaryValue, randomIndex;

  while (0 !== currentIndex) {

    randomIndex = Math.floor(Math.random() * currentIndex);
    currentIndex -= 1;

    temporaryValue = array[currentIndex];
    array[currentIndex] = array[randomIndex];
    array[randomIndex] = temporaryValue;
  }

  return array;
}

// data for the sparklines that appear below header area
var sparklineData = [47, 45, 54, 38, 56, 24, 65, 31, 37, 39, 62, 51, 35, 41, 35, 27, 93, 53, 61, 27, 54, 43, 19, 46];
// the default colorPalette for this dashboard
//var colorPalette = ['#01BFD6', '#5564BE', '#F7A600', '#EDCD24', '#F74F58'];
var colorPalette = ['#00D8B6','#008FFB',  '#FEB019', '#FF4560', '#775DD0']


var spark1 = {
  chart: {
    defaultLocale: 'es',
    locales: [{
      name: 'es',
      options: {
        months: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
        shortMonths: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        days: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
        shortDays: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
        toolbar: {
          download: 'Descargar SVG',
          selection: 'Seleccionar',
          selectionZoom: 'Selection Zoom',
          zoomIn: 'Zoom In',
          zoomOut: 'Zoom Out',
          pan: 'Panning',
          reset: 'Reset Zoom',
        }
      }
    }],
    id: 'sparkline1',
    type: 'area',
    height: 160,
    sparkline: {
      enabled: true
    },
	toolbar
  },
  stroke: {
    curve: 'straight'
  },
    dataLabels: {
          enabled: false
        },
  series: [{
	
	name: 'Total',
	data: phpTotal
  },{
    name: 'Ventas',
    data: phpVentas
  }],
    labels:phpDias,
     yaxis: [{
          title: {
            text: 'Total'
				},
			labels: {
				formatter: function (value) {
					return new Intl.NumberFormat('es-CL', {currency: 'CLP', style: 'currency'}).format(value);
				}
			  }				
        
        }, {
          opposite: true,
		  
          title: {
            text: 'Ventas'
          }
        }],
  xaxis: {
    type: 'datetime',
  },

  title: {
    text: phpVentas.reduce((a, b) => a + b, 0) + ' Ventas - ' + new Intl.NumberFormat('es-CL', {currency: 'CLP', style: 'currency'}).format(phpTotal.reduce((a, b) => a + b, 0) ),

    offsetX: 30,
    style: {
      fontSize: '24px',
      cssClass: 'apexcharts-yaxis-title'
    }
  },
  subtitle: {
    text: 'Acumulado',
    offsetX: 30,
    style: {
      fontSize: '14px',
      cssClass: 'apexcharts-yaxis-title'
    }
  }
}

var spark2 = {
  chart: {
    id: 'sparkline2',
    group: 'sparklines',
    type: 'area',
    height: 170,
    sparkline: {
      enabled: true
    },
	toolbar
  },
  stroke: {
    curve: 'straight'
  },
    dataLabels: {
          enabled: false
        },
  series: [
  {
	name: 'Total',
	data: phpTotalSemanaCuatro
  },
  {
    name: 'Ventas',
    data: phpVentasSemanaCuatro
  }],
	labels: phpDiasSemanaCuatro,
        yaxis: [{
          title: {
            text: 'Total'
				},
			labels: {
				formatter: function (value) {
					return new Intl.NumberFormat('es-CL', {currency: 'CLP', style: 'currency'}).format(value);
				}
			  }				
        
        }, {
          opposite: true,
		  
          title: {
            text: 'Ventas'
          }
        }],
  xaxis: {
    type: 'datetime',
  },

  title: {
    text: phpVentasSemanaCuatro.reduce((a, b) => a + b, 0) + ' Ventas - ' + new Intl.NumberFormat('es-CL', {currency: 'CLP', style: 'currency'}).format(totalSemanaCuatro),
						

    offsetX: 30,
    style: {
      fontSize: '24px',
      cssClass: 'apexcharts-yaxis-title'
    }
  },
  subtitle: {
    text: ' ',
    offsetX: 30,
    style: {
      fontSize: '14px',
      cssClass: 'apexcharts-yaxis-title'
    }
  }
}

new ApexCharts(document.querySelector("#spark1"), spark1).render();
new ApexCharts(document.querySelector("#spark2"), spark2).render();



var optionsBar = {
  
          series: [{
          name: 'Ganacias Totales',
          type: 'column',
          data: phpVentaMensualTotal
        }, {
          name: 'Ventas Totales',
          type: 'line',
          data: phpVentaMensualCantidad
        }],
          chart: {
          height: '460',
          width: '100%',
          type: 'line',
          defaultLocale: 'en',
          locales: [{
            name: 'en',
            options: {
              months: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
              shortMonths: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
              days: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
              shortDays: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
              toolbar: {
                download: 'Descargar SVG',
                selection: 'Selection',
                selectionZoom: 'Seleccionar Zoom',
                zoomIn: 'Aumentar',
                zoomOut: 'Disminuir',
                pan: 'Mover',
                reset: 'Reiniciar Zoom',
              }
            }
          }],
		  toolbar
        },
        stroke: {
          width: [0, 4]
        },
        title: {
          text: ' '
        },
        dataLabels: {
          enabled: true,
          enabledOnSeries: [1]
        },

		labels: ['Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic'],
        yaxis: [{
          title: {
            text: 'Total'
				},
			labels: {
				formatter: function (value) {
					return new Intl.NumberFormat('es-CL', {currency: 'CLP', style: 'currency'}).format(value);
				}
			  }				
        
        }, {
          opposite: true,
          title: {
            text: 'Ventas'
          }
        }]
        };

var chartBar = new ApexCharts(document.querySelector('#bar'), optionsBar);
chartBar.render();


var optionDonut = {
  chart: {
      type: 'pie',
      width: '100%',
      height: 500,
	  toolbar
  },
  
  dataLabels: {
    enabled: true,
  },

  title: {
    text:  phpVentaMensualCantidad.pop() + ' Ventas - ' + new Intl.NumberFormat('es-CL', {currency: 'CLP', style: 'currency'}).format(phpVentaMensualTotal.pop()),

    offsetX: 30,
    style: {
      fontSize: '24px',
      cssClass: 'apexcharts-yaxis-title'
    }
  },
  plotOptions: {
    pie: {
      customScale: 0.8,
      donut: {
        size: '100%',
      },
      offsetY: 0,
    },
    stroke: {
      colors: undefined
    }
  },
  colors: colorPalette,
  series: phpCategoriasCantidad,
  labels: phpCategorias,
  legend: {
    position: 'bottom',
    offsetY: 0,
	
  }
}

var donut = new ApexCharts(
  document.querySelector("#donut"),
  optionDonut
)
donut.render();
