<?php require_once("common/bdatos.php");



function select_UltimaVenta()
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " v.ventaId  ";
  $sql = $sql . " FROM by_venta v";
  $sql = $sql . " ORDER BY v.ventaId DESC";
  $sql = $sql . " LIMIT 1 ";

  // echo $sql;
  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_Venta($ventaId)
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " v.ventaId  		,";
  $sql = $sql . " v.clienteId		,";
  $sql = $sql . " v.fecha  			,";
  $sql = $sql . " v.montoTotal  	,";
  $sql = $sql . " v.formaPagoId  	,";
  $sql = $sql . " v.ventaEstadoId  	,";
  $sql = $sql . " v.vuelto		  	,";
  $sql = $sql . " v.observaciones  	,";
  $sql = $sql . " v.vendedorId		 ";
  $sql = $sql . " FROM by_venta v";
  $sql = $sql . " WHERE ventaId = " . $ventaId;

  // echo $sql;
  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_Ventas()
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " v.ventaId  ,";
  $sql = $sql . " c.nombre   ,";
  $sql = $sql . " v.fecha	   ,";
  $sql = $sql . " v.montoTotal  ,";
  $sql = $sql . " f.formaDePago  ";
  $sql = $sql . " FROM by_venta v";
  $sql = $sql . " JOIN by_cliente c";
  $sql = $sql . " ON c.clienteId = v.clienteId";
  $sql = $sql . " JOIN by_formaDePago f";
  $sql = $sql . " ON v.formaPagoId = f.formaDePagoId";

  $sql = $sql . " ORDER BY v.ventaId DESC";

  // echo $sql;
  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_Ventas_Por_Filtro_Vendedor($txtNombreCliente, $intFormaPagoId, $txtFechaDesde, $txtFechaHasta, $intVentas)
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " v.ventaId  ,";
  $sql = $sql . " c.nombre   ,";
  $sql = $sql . " v.fecha	   ,";
  $sql = $sql . " v.montoTotal  ,";
  $sql = $sql . " f.formaDePago  ,";
  $sql = $sql . " vd.nombre  ";
  $sql = $sql . " FROM by_venta v";
  $sql = $sql . " JOIN by_cliente c";
  $sql = $sql . " ON c.clienteId = v.clienteId";
  $sql = $sql . " JOIN by_formaDePago f";
  $sql = $sql . " ON v.formaPagoId = f.formaDePagoId";
  $sql = $sql . " LEFT JOIN by_vendedor vd";
  $sql = $sql . " ON vd.vendedorId = v.vendedorId ";
  $sql = $sql . " JOIN by_ventaEstado e";
  $sql = $sql . " ON v.ventaEstadoId = e.ventaEstadoId";
  $sql = $sql . "	WHERE e.ventaEstadoId != 3";

  if (!empty($txtNombreCliente)) {
    $sql = $sql . " AND (c.nombre LIKE '%" . $txtNombreCliente . "%')";
  }

  if (!empty($intFormaPagoId) && $intFormaPagoId > 0) {
    $sql = $sql . " AND f.formaDePagoId = " . $intFormaPagoId;
  }


  if (!empty($txtFechaDesde)) {
    $sql = $sql . " AND v.fecha >= '" . $txtFechaDesde . "'";
  }

  if (!empty($txtFechaHasta)) {
    $sql = $sql . " AND v.fecha <= '" . $txtFechaHasta . "'";
  }
  
  if (!empty($intVentas)) {
    $sql = $sql . " AND vd.vendedorId = " . $intVentas;
  }

  $sql = $sql . " ORDER BY v.ventaId DESC";

  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}


function select_Ventas_Por_Filtro($txtNombreCliente, $intFormaPagoId, $txtFechaDesde, $txtFechaHasta)
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " v.ventaId  ,";
  $sql = $sql . " c.nombre   ,";
  $sql = $sql . " v.fecha	   ,";
  $sql = $sql . " v.montoTotal  ,";
  $sql = $sql . " f.formaDePago  ,";
  $sql = $sql . " vd.nombre  ";
  $sql = $sql . " FROM by_venta v";
  $sql = $sql . " JOIN by_cliente c";
  $sql = $sql . " ON c.clienteId = v.clienteId";
  $sql = $sql . " JOIN by_formaDePago f";
  $sql = $sql . " ON v.formaPagoId = f.formaDePagoId";
  $sql = $sql . " LEFT JOIN by_vendedor vd";
  $sql = $sql . " ON vd.vendedorId = v.vendedorId ";
  $sql = $sql . " JOIN by_ventaEstado e";
  $sql = $sql . " ON v.ventaEstadoId = e.ventaEstadoId";
  $sql = $sql . "	WHERE e.ventaEstadoId != 3";

  if (!empty($txtNombreCliente)) {
    $sql = $sql . " AND (c.nombre LIKE '%" . $txtNombreCliente . "%')";
  }

  if (!empty($intFormaPagoId) && $intFormaPagoId > 0) {
    $sql = $sql . " AND f.formaDePagoId = " . $intFormaPagoId;
  }


  if (!empty($txtFechaDesde)) {
    $sql = $sql . " AND v.fecha >= '" . $txtFechaDesde . "'";
  }

  if (!empty($txtFechaHasta)) {
    $sql = $sql . " AND v.fecha <= '" . $txtFechaHasta . "'";
  }
  
  if (!empty($intVentas)) {
    $sql = $sql . " AND vd.vendedorId = " . $intVentas;
  }

  $sql = $sql . " ORDER BY v.ventaId DESC";

  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_Ventas_Por_Ano($txtAno){
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " v.ventaId  ,";
  $sql = $sql . " c.nombre   ,";
  $sql = $sql . " v.fecha	   ,";
  $sql = $sql . " v.montoTotal  ,";
  $sql = $sql . " f.formaDePago  ";
  $sql = $sql . " FROM by_venta v";
  $sql = $sql . " JOIN by_cliente c";
  $sql = $sql . " ON c.clienteId = v.clienteId";
  $sql = $sql . " JOIN by_formaDePago f";
  $sql = $sql . " ON v.formaPagoId = f.formaDePagoId";
  $sql = $sql . " JOIN by_ventaEstado e";
  $sql = $sql . " ON v.ventaEstadoId = e.ventaEstadoId";
  $sql = $sql . "	WHERE e.ventaEstadoId != 3";

  if (!empty($txtAno)) {
    if ($txtAno != 0){
      $sql = $sql . " AND YEAR(v.fecha) = '" . $txtAno . "'";
    }
  }


  $sql = $sql . " ORDER BY v.ventaId DESC";

  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_ventas_por_producto($txtAno)
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " SUM(v.cantidad),";
  $sql = $sql . " v.productoId, ";
  $sql = $sql . " SUM(v.valorTotal), ";
  $sql = $sql . " v.observaciones ,  ";
  $sql = $sql . " p.descripcion   ,";
  $sql = $sql . " COUNT(v.cantidad)  ,";
  $sql = $sql . " YEAR(by_venta.fecha), ";
  $sql = $sql . " by_venta.ventaEstadoId, ";
  // $sql = $sql . " ROUND(SUM(cd.valorTotal))";
  $sql = $sql . " (SELECT SUM(valorTotal) FROM by_compraDetalle WHERE productoId = v.productoId)'TOTAL COMPRA'";
  $sql = $sql . " FROM by_ventaDetalle v ";
  $sql = $sql . " JOIN by_producto p on p.productoId = v.productoId ";
  $sql = $sql . " JOIN by_venta  on by_venta.ventaId = v.ventaId";
  $sql = $sql . " JOIN by_compraDetalle cd ON cd.productoId = p.productoId";
  $sql = $sql . " WHERE 1 = 1";
  $sql = $sql . " AND p.estaActivo = 1";
  $sql = $sql . " AND (by_venta.ventaEstadoId != 3)";

  if (!empty($txtAno)){
    $sql = $sql . " AND YEAR(by_venta.fecha) = ". $txtAno;
  }

  $sql = $sql . " GROUP BY v.productoId ";

  // echo $sql;


  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_compras_por_producto($txtAno)
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " SUM(v.cantidad),";
  $sql = $sql . " v.productoId, ";
  $sql = $sql . " SUM(v.valorTotal), ";
  $sql = $sql . " v.observaciones ,  ";
  $sql = $sql . " p.descripcion   ,";
  $sql = $sql . " COUNT(v.cantidad)  ,";
  $sql = $sql . " YEAR(by_compra.fecha), ";
  $sql = $sql . " by_compra.compraEstadoId ";
  $sql = $sql . " FROM by_compraDetalle v ";
  $sql = $sql . " JOIN by_producto p on p.productoId = v.productoId ";
  $sql = $sql . " JOIN by_compra  on by_compra.ventaId = v.ventaId";
  $sql = $sql . " WHERE 1 = 1";
  $sql = $sql . " AND p.estaActivo = 1";
  $sql = $sql . " AND (by_compra.ventaEstadoId != 3)";

  if (!empty($txtAno)){
    $sql = $sql . " AND YEAR(by_venta.fecha) = ". $txtAno;
  }

  $sql = $sql . " GROUP BY v.productoId ";

  // echo $sql;

  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_Ventas_Semana_Pasada()
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " v.ventaId  ,";
  $sql = $sql . " c.nombre   ,";
  $sql = $sql . " v.fecha	   ,";
  $sql = $sql . " v.montoTotal  ,";
  $sql = $sql . " f.formaDePago  ";
  $sql = $sql . " FROM by_venta v";
  $sql = $sql . " JOIN by_cliente c";
  $sql = $sql . " ON c.clienteId = v.clienteId";
  $sql = $sql . " JOIN by_formaDePago f";
  $sql = $sql . " ON v.formaPagoId = f.formaDePagoId";
  $sql = $sql . " JOIN by_ventaEstado e";
  $sql = $sql . " ON v.ventaEstadoId = e.ventaEstadoId";
  $sql = $sql . " WHERE v.fecha >= curdate() - INTERVAL DAYOFWEEK(curdate())+5 DAY";
  $sql = $sql . " AND fecha < curdate() - INTERVAL DAYOFWEEK(curdate())-2 DAY";


  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_Ventas_Diarias($fecha)
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " fecha ,";
  $sql = $sql . " count(ventaId) ,";
  $sql = $sql . " sum(montoTotal) ";
  $sql = $sql . " FROM by_venta ";
  $sql = $sql . " WHERE YEARWEEK(`fecha`, 1) >= YEARWEEK('". $fecha ."', 1)";
  $sql = $sql . "AND ventaEstadoId != 3";
  $sql = $sql . " GROUP BY fecha";


  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_Ventas_Semanas($fecha)
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " YEARWEEK(`fecha`, 1) ,";
  $sql = $sql . " count(ventaId) ,";
  $sql = $sql . " sum(montoTotal) ";
  $sql = $sql . " FROM by_venta ";
  $sql = $sql . " WHERE YEARWEEK(`fecha`, 1) >= YEARWEEK('". $fecha ."', 1)";
  $sql = $sql . " GROUP BY YEARWEEK(`fecha`, 1)";

  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_Ventas_Mensuales($fecha)
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " EXTRACT( MONTH FROM (`fecha`)) ,";
  $sql = $sql . " count(ventaId) ,";
  $sql = $sql . " sum(montoTotal) ";
  $sql = $sql . " FROM by_venta ";
  $sql = $sql . " WHERE EXTRACT( YEAR FROM (`fecha`)) >= EXTRACT( YEAR FROM ('". $fecha ."'))";
  $sql = $sql . "AND ventaEstadoId != 3";
  $sql = $sql . " GROUP BY EXTRACT( MONTH FROM (`fecha`))";

  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}

function select_Ventas_Por_Categoria($fecha)
{
  global $sql, $arrResultado;

  $sql = "SELECT ";
  $sql = $sql . " pc.categoria ,";
  $sql = $sql . "  COUNT(pc.categoria) ,";
  $sql = $sql . "  SUM(v.montoTotal) ";
  $sql = $sql . "  FROM by_ventaDetalle vd";
  $sql = $sql . "  INNER JOIN by_venta v ON vd.ventaid = v.ventaId ";
  $sql = $sql . "  INNER JOIN by_producto p ON p.productoId = vd.productoId  ";
  $sql = $sql . "  INNER JOIN by_productoCategoria pc ON p.productoCategoriaId = pc.productoCategoriaId ";
  $sql = $sql . "  WHERE v.fecha >= '" . $fecha . "'";
  $sql = $sql . "  AND ventaEstadoId != 3";
  $sql = $sql . "  GROUP BY pc.categoria";


  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}



/*
SELECT fecha, count(ventaId), sum(montoTotal) FROM `by_venta` WHERE YEARWEEK(`fecha`, 1) = YEARWEEK(CURDATE(), 1)

 GROUP BY fecha


SELECT fecha, count(ventaId), sum(montoTotal) FROM `by_venta` 
WHERE fecha >= curdate() - INTERVAL DAYOFWEEK(curdate())+2 DAY AND fecha < curdate() - INTERVAL DAYOFWEEK(curdate())-2 DAY GROUP BY fecha

*/

function select_resumen_caja($diaActual)
{
  global $sql, $arrResultado;

  $sql = "SELECT 
	COUNT(ventaId), 
  SUM(montoTotal),
 	IFNULL((SELECT SUM(montoTotal) FROM by_venta WHERE (formaPagoId = 1) AND fecha = '" . $diaActual . "' ),0) 'efectivo' ,
 	IFNULL((SELECT SUM(montoTotal) FROM by_venta WHERE (formaPagoId = 2) AND fecha = '" . $diaActual . "' ),0) 'debito' ,
 	IFNULL((SELECT SUM(montoTotal) FROM by_venta WHERE (formaPagoId = 3) AND fecha = '" . $diaActual . "' ),0) 'credito' ,
 	IFNULL((SELECT SUM(montoTotal) FROM by_venta WHERE (formaPagoId = 4) AND fecha = '" . $diaActual . "' ),0) 'transferencia' ,
 	IFNULL((SELECT SUM(montoTotal) FROM by_venta WHERE (formaPagoId = 5) AND fecha = '" . $diaActual . "' ),0) 'otros' ,
 	IFNULL((SELECT SUM(montoTotal) FROM by_venta WHERE (formaPagoId = 6) AND fecha = '" . $diaActual . "' ),0) 'mixto' 
  FROM by_venta WHERE 1 = 1 AND fecha = '" . $diaActual . "' ;";


  // echo $sql;
  $arrResultado = ejecutar($sql, "Select");
  return $arrResultado;
}
